@props([
    'label' => false,
    'model' => false,
    'modelvalue' => false
])
    @if ($label)
        <label class="block text-gray-700 text-sm font-bold mb-2">{{ $label }}</label>
    @endif
    
    <div 
    @if ($modelvalue == 1)
    x-data="{ toggleIs: true}" 
    @else
    x-data="{ toggleIs: false}" 
    @endif
    class="relative inline-block w-10 mr-2 align-middle select-none transition duration-200 ease-in" @click="toggleIs = !toggleIs"
    >
    <input type="checkbox" name="toggle" id="toggle" class="toggle-checkbox absolute block w-6 h-6 rounded-full bg-white border-4 appearance-none cursor-pointer" :class="{ 'right-0 border-green-500': toggleIs }"
        @if ($model)
        wire:model="{{ $model }}"
        @endif
        />
    <label for="toggle" class="toggle-label block overflow-hidden h-6 rounded-full bg-gray-300 cursor-pointer"  :class="{ 'bg-green-500': toggleIs }"></label>
    </div>