@props([
    'leadingAddOn' => false,
    'trailingAddOn' => false,
    'label' => false,
    'showcurrency' => false,
])


    @if ($label)
        <label class="block text-gray-700 text-sm font-bold mb-2">{{ $label }}</label>
    @endif

<div class="flex rounded-md shadow-sm">
    @if ($showcurrency)
        <span class="inline-flex items-center px-3 rounded-l-md border border-r-0 border-gray-300 bg-gray-50 text-gray-500 sm:text-sm">
            £
        </span>
    @elseif ($leadingAddOn)
        <span class="inline-flex items-center px-3 rounded-l-md border border-r-0 border-gray-300 bg-gray-50 text-gray-500 sm:text-sm">
            {{ $leadingAddOn }}
        </span>
    @endif

    <input {{ $attributes->merge(['class' => 'flex-1 form-input border-cool-gray-300 block w-full transition duration-150 ease-in-out sm:text-sm sm:leading-5' . ($leadingAddOn ? ' rounded-none rounded-r-md' : '') . ($showcurrency ? ' rounded-none rounded-r-md' : '') . ($trailingAddOn ? ' rounded-none rounded-l-md text-right' : '')]) }}/>
    
    @if ($trailingAddOn)
        <span class="inline-flex items-center px-3 rounded-r-md border border-l-0 border-gray-300 bg-gray-50 text-gray-500 sm:text-sm">
            {{ $trailingAddOn }}
        </span>
    @endif
</div>